//
//  OPUserSettings.h
//  ApplicationFrameworks
//
//  Created by Nathan Van Fleet on 2015-04-29.
//
//

#import <Foundation/Foundation.h>

// A combination of sharedUserDefaults (if iOS) and standardUserDefaults

@interface OPUserSettings : NSObject

+ (OPUserSettings *)userSettings;

// Not usually necessary to call in the case of regular setting of data
- (void)synchronize;

- (id)objectForKey:(NSString *)defaultName;
- (void)setObject:(id)value forKey:(NSString *)defaultName;
- (void)removeObjectForKey:(NSString *)defaultName;

- (NSDictionary *)dictionaryRepresentation;
- (NSDictionary *)persistentDomainForName:(NSString *)domainName;
- (void)setPersistentDomain:(NSDictionary *)dictionary forName:(NSString *)domainName;
- (void)removePersistentDomainForName:(NSString *)domainName;
- (void)registerDefaults:(NSDictionary *)defaults;
@end

@interface OPUserSettings (Convenience)
- (NSString *)stringForKey:(NSString *)defaultName;
- (NSArray *)arrayForKey:(NSString *)defaultName;
- (NSDictionary *)dictionaryForKey:(NSString *)defaultName;
- (NSData *)dataForKey:(NSString *)defaultName;
- (NSArray *)stringArrayForKey:(NSString *)defaultName;
- (NSInteger)integerForKey:(NSString *)defaultName;
- (float)floatForKey:(NSString *)defaultName;
- (double)doubleForKey:(NSString *)defaultName;
- (BOOL)boolForKey:(NSString *)defaultName;
- (NSURL *)URLForKey:(NSString *)defaultName;

- (void)setInteger:(NSInteger)value forKey:(NSString *)defaultName;
- (void)setFloat:(float)value forKey:(NSString *)defaultName;
- (void)setDouble:(double)value forKey:(NSString *)defaultName;
- (void)setBool:(BOOL)value forKey:(NSString *)defaultName;
- (void)setURL:(NSURL *)url forKey:(NSString *)defaultName;
@end

@interface OPUserSettings (LargeBreadthMethods)
- (void)removeAllSyncSettings;
- (void)clearStoredTransportSecrets;
- (void)migrateUserDefaultsFromVersion4;
- (BOOL)isSettingsCanaryAliveAndWell;
- (NSString *)diagnosticsString;
- (void)clearUserDefaults;
@end

@interface OPUserSettings (B5UserAccount)
- (BOOL)hasNotifiedUserAboutAwaitingRecoveryForUserAccountUUID:(NSString *)accountUUID;
- (void)setHasNotifiedUserAboutAwaitingRecoveryForUserAccountUUID:(NSString *)accountUUID;
- (void)resetNotifiedUserAboutAwaitingRecoveryForUserAccountUUID:(NSString *)accountUUID;
@end